/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.lock;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.lock.Lockable;
import com.ibm.hsc.lock.RequestItem;
import com.ibm.hsc.lock.RequestQueue;
import java.util.Hashtable;
import java.util.Vector;

public class GroupLock
implements Lockable {
    private int mSize;
    private Vector mLockVec;
    private static Hashtable sGroupLockHash = new Hashtable();
    private static Hashtable sStatusHash = new Hashtable();
    private int mStatus;
    static /* synthetic */ Class class$com$ibm$hsc$lock$RequestQueue;

    private GroupLock(Vector vector) {
        this.mSize = vector.size();
        this.mLockVec = vector;
        this.mStatus = 0;
    }

    public boolean isRunning() {
        return this.mStatus == 1;
    }

    public static GroupLock create(Vector vector) throws PIHscServerException {
        if (vector == null || vector.size() < 1) {
            System.out.println("GroupLock invalid lock objects");
            throw new PIHscServerException("3201");
        }
        for (int i = 0; i < vector.size(); ++i) {
            Lock lock = (Lock)vector.elementAt(i);
            for (int j = i + 1; j < vector.size(); ++j) {
                Lock lock2 = (Lock)vector.elementAt(j);
                if (!lock.related(lock2)) continue;
                System.out.println("GroupLock invalid lock objects");
                throw new PIHscServerException("3201");
            }
        }
        return new GroupLock(vector);
    }

    public static GroupLock get(Thread thread) {
        return (GroupLock)sGroupLockHash.get(thread);
    }

    public static int getLockStatus(Thread thread) {
        return (Integer)sStatusHash.get(thread);
    }

    public static void setLockStatus(Thread thread, int n) {
        sStatusHash.put(thread, new Integer(n));
    }

    public Vector getLockVec() {
        return this.mLockVec;
    }

    public String toString() {
        return "GroupLock" + this.mLockVec;
    }

    public int lock(int n) throws PIHscServerException {
        return this.lock(n, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lock(int n, long l) throws PIHscServerException {
        Thread thread = Thread.currentThread();
        Class clazz = class$com$ibm$hsc$lock$RequestQueue == null ? (class$com$ibm$hsc$lock$RequestQueue = GroupLock.class$("com.ibm.hsc.lock.RequestQueue")) : class$com$ibm$hsc$lock$RequestQueue;
        synchronized (clazz) {
            int n2;
            if (sGroupLockHash.containsKey(thread)) {
                System.out.println("GroupLock exists");
                throw new PIHscServerException("3201");
            }
            sGroupLockHash.put(thread, this);
            sStatusHash.put(thread, new Integer(0));
            int n3 = 0;
            this.mStatus = 0;
            for (n2 = 0; n2 < this.mSize; ++n2) {
                if (((Lock)this.mLockVec.get(n2)).lock(n, l) != 1) continue;
                ++n3;
            }
            if (n3 == this.mSize) {
                System.out.println("GroupLock lock: " + thread + "-" + this);
                this.mStatus = 1;
                return 1;
            }
            do {
                block13: {
                    try {
                        if (Lock.debug) {
                            System.out.println(thread + "-" + this + " is waiting.");
                        }
                        if (l > 0L) {
                            (class$com$ibm$hsc$lock$RequestQueue == null ? (class$com$ibm$hsc$lock$RequestQueue = GroupLock.class$("com.ibm.hsc.lock.RequestQueue")) : class$com$ibm$hsc$lock$RequestQueue).wait(l);
                            throw new PIHscServerException("3202");
                        }
                        (class$com$ibm$hsc$lock$RequestQueue == null ? GroupLock.class$("com.ibm.hsc.lock.RequestQueue") : class$com$ibm$hsc$lock$RequestQueue).wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (Lock.debug) {
                            System.out.println(thread + "-" + this + " interrupted");
                        }
                        if (GroupLock.getLockStatus(thread) != -1) break block13;
                        sGroupLockHash.remove(thread);
                        sStatusHash.remove(thread);
                        System.out.println("GroupLock: Acquiring group lock " + this + " failed");
                        throw new PIHscServerException("3205");
                    }
                }
                n3 = 0;
                for (n2 = 0; n2 < this.mSize; ++n2) {
                    if (this.checkLockState((Lock)this.mLockVec.get(n2)) != 1) continue;
                    ++n3;
                }
            } while (n3 < this.mSize);
            System.out.println("GroupLock lock: " + thread + "-" + this);
            this.mStatus = 1;
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockSwitchFrom(Lock lock) throws PIHscServerException {
        Thread thread = Thread.currentThread();
        Class clazz = class$com$ibm$hsc$lock$RequestQueue == null ? (class$com$ibm$hsc$lock$RequestQueue = GroupLock.class$("com.ibm.hsc.lock.RequestQueue")) : class$com$ibm$hsc$lock$RequestQueue;
        synchronized (clazz) {
            RequestQueue.switchToGroupLock(lock, this);
            sGroupLockHash.put(thread, this);
            sStatusHash.put(thread, new Integer(1));
            this.mStatus = 1;
            System.out.println("lock switching done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws PIHscServerException {
        Class clazz = class$com$ibm$hsc$lock$RequestQueue == null ? (class$com$ibm$hsc$lock$RequestQueue = GroupLock.class$("com.ibm.hsc.lock.RequestQueue")) : class$com$ibm$hsc$lock$RequestQueue;
        synchronized (clazz) {
            System.out.println("GroupLock unlock: " + Thread.currentThread() + "-" + this);
            GroupLock groupLock = (GroupLock)sGroupLockHash.remove(Thread.currentThread());
            sStatusHash.remove(Thread.currentThread());
            this.mStatus = 0;
            if (groupLock == null) {
                System.out.println("GroupLock not held");
                throw new PIHscServerException("3204");
            }
            for (int i = 0; i < this.mSize; ++i) {
                try {
                    ((Lock)this.mLockVec.get(i)).unlock();
                    continue;
                }
                catch (Throwable throwable) {
                    System.out.println("Warning: Unlock grouplock exception");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Lock lock) throws PIHscServerException {
        Class clazz = class$com$ibm$hsc$lock$RequestQueue == null ? (class$com$ibm$hsc$lock$RequestQueue = GroupLock.class$("com.ibm.hsc.lock.RequestQueue")) : class$com$ibm$hsc$lock$RequestQueue;
        synchronized (clazz) {
            System.out.println("GroupLock unlock: " + lock + " of " + this);
            GroupLock groupLock = (GroupLock)sGroupLockHash.get(Thread.currentThread());
            if (groupLock == null) {
                System.out.println("GroupLock not held");
                throw new PIHscServerException("3204");
            }
            try {
                for (int i = 0; i < this.mSize; ++i) {
                    if (!lock.equals((Lock)this.mLockVec.get(i))) continue;
                    lock.unlock();
                    System.out.println("unlockDone: " + lock);
                    break;
                }
            }
            catch (Throwable throwable) {
                System.out.println(" Unlock exception: " + throwable);
            }
        }
    }

    private int checkLockState(Lock lock) throws PIHscServerException {
        Thread thread = Thread.currentThread();
        RequestQueue requestQueue = RequestQueue.getRequestQueue(lock);
        RequestItem requestItem = requestQueue.get(thread, lock);
        if (requestItem == null) {
            System.out.println("Lock: Lock not held " + thread);
            throw new PIHscServerException("3204");
        }
        if (requestItem.getStatus() == 2) {
            return 1;
        }
        if (requestItem.getLockType() != 2 && requestItem.getLockType() != 3) {
            return 2;
        }
        RequestItem requestItem2 = requestQueue.getTopRelatedRequest(requestItem);
        if (requestItem2 != null) {
            if (Lock.debug) {
                System.out.println("checkLockState: ri=" + requestItem + " topReq=" + requestItem2);
            }
            if (requestItem2.equals(requestItem) && requestItem2.getStatus() == 1) {
                if (Lock.debug) {
                    System.out.println("checkLockState: " + requestItem + " set running");
                }
                requestItem.setStatus(2);
                return 1;
            }
        }
        return 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

